/*
 * Decompiled with CFR 0.152.
 */
package me.towdium.jecharacters;

import com.google.gson.GsonBuilder;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Objects;
import me.towdium.jecharacters.JechConfig;
import me.towdium.jecharacters.JustEnoughCharacters;
import me.towdium.jecharacters.utils.Match;
import me.towdium.jecharacters.utils.Profiler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.ChatScreen;
import net.minecraft.command.CommandSource;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class JechCommand {
    static CommandDispatcher<ISuggestionProvider> dispatcher;
    static LiteralArgumentBuilder<ISuggestionProvider> builder;

    private static LiteralArgumentBuilder<ISuggestionProvider> literal(String s) {
        return LiteralArgumentBuilder.literal((String)s);
    }

    private static int setKeyboard(JechConfig.Spell keyboard) {
        JechConfig.enumKeyboard.set((Object)keyboard);
        JechConfig.enableQuote.set((Object)false);
        Match.onConfigChange();
        return 0;
    }

    private static int profile() {
        Thread t = new Thread(() -> {
            JustEnoughCharacters.printMessage((ITextComponent)new TranslationTextComponent("jecharacters.chat.start"));
            Profiler.Report r = Profiler.run();
            try (FileOutputStream fos = new FileOutputStream("logs/jecharacters.txt");){
                OutputStreamWriter osw = new OutputStreamWriter(fos);
                osw.write(new GsonBuilder().setPrettyPrinting().create().toJson((Object)r));
                osw.flush();
                JustEnoughCharacters.printMessage((ITextComponent)new TranslationTextComponent("jecharacters.chat.saved"));
            }
            catch (IOException e) {
                JustEnoughCharacters.printMessage((ITextComponent)new TranslationTextComponent("jecharacters.chat.error"));
            }
        });
        t.setPriority(1);
        t.start();
        return 0;
    }

    @SubscribeEvent
    public static void onOpenGui(GuiScreenEvent.InitGuiEvent event) {
        RootCommandNode root;
        if (event.getGui() instanceof ChatScreen && (root = JechCommand.getPlayer().field_71174_a.func_195515_i().getRoot()).getChild("jech") == null) {
            root.addChild((CommandNode)builder.build());
        }
    }

    @SubscribeEvent
    public static void onCommand(ClientChatEvent event) {
        block6: {
            CommandSource cs = JechCommand.getPlayer().func_195051_bN();
            String msg = event.getMessage();
            if (msg.startsWith("/jech ") || msg.equals("/jech")) {
                event.setCanceled(true);
                Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146239_a(msg);
                try {
                    StringReader stringreader = new StringReader(msg);
                    if (stringreader.canRead() && stringreader.peek() == '/') {
                        stringreader.skip();
                    }
                    ParseResults parse = dispatcher.parse(stringreader, (Object)cs);
                    dispatcher.execute(parse);
                }
                catch (CommandSyntaxException e) {
                    cs.func_197021_a(TextComponentUtils.func_202465_a((Message)e.getRawMessage()));
                    if (e.getInput() == null || e.getCursor() < 0) break block6;
                    int k = Math.min(e.getInput().length(), e.getCursor());
                    StringTextComponent tc1 = new StringTextComponent("");
                    tc1.func_240699_a_(TextFormatting.GRAY).func_240700_a_(i -> i.func_240715_a_(new ClickEvent(ClickEvent.Action.SUGGEST_COMMAND, event.getMessage())));
                    if (k > 10) {
                        tc1.func_240702_b_("...");
                    }
                    tc1.func_240702_b_(e.getInput().substring(Math.max(0, k - 10), k));
                    if (k < e.getInput().length()) {
                        IFormattableTextComponent tc2 = new StringTextComponent(e.getInput().substring(k)).func_240701_a_(new TextFormatting[]{TextFormatting.RED, TextFormatting.UNDERLINE});
                        tc1.func_150253_a().add(tc2);
                    }
                    tc1.func_150253_a().add(new TranslationTextComponent("command.context.here").func_240701_a_(new TextFormatting[]{TextFormatting.RED, TextFormatting.ITALIC}));
                    cs.func_197021_a((ITextComponent)tc1);
                }
            }
        }
    }

    private static ClientPlayerEntity getPlayer() {
        return Objects.requireNonNull(Minecraft.func_71410_x().field_71439_g);
    }

    static {
        builder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)JechCommand.literal("jech").executes(c -> {
            JustEnoughCharacters.printMessage((ITextComponent)new TranslationTextComponent("jecharacters.chat.help"));
            return 0;
        })).then(JechCommand.literal("profile").executes(c -> JechCommand.profile()))).then(((LiteralArgumentBuilder)JechCommand.literal("verbose").then(JechCommand.literal("true").executes(c -> {
            JechConfig.enableVerbose.set((Object)true);
            return 0;
        }))).then(JechCommand.literal("false").executes(c -> {
            JechConfig.enableVerbose.set((Object)false);
            return 0;
        })))).then(JechCommand.literal("silent"))).executes(c -> {
            JechConfig.enableChat.set((Object)false);
            return 0;
        })).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)JechCommand.literal("keyboard").then(JechCommand.literal("QUANPIN").executes(c -> JechCommand.setKeyboard(JechConfig.Spell.QUANPIN)))).then(JechCommand.literal("DAQIAN").executes(c -> JechCommand.setKeyboard(JechConfig.Spell.DAQIAN)))).then(JechCommand.literal("XIAOHE").executes(c -> JechCommand.setKeyboard(JechConfig.Spell.XIAOHE)))).then(JechCommand.literal("ZIRANMA").executes(c -> JechCommand.setKeyboard(JechConfig.Spell.ZIRANMA))));
        dispatcher = new CommandDispatcher();
        dispatcher.register(builder);
    }
}

